<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	ini_set('max_execution_time', 1200);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "getExternenJson opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "getExternenJson opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "getExternenJson opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}	

	$session_hash = $_GET['session_hash']; 
	$lerarenid	  = $_GET['lerarenid'];
	
	$verify_url = $toolbox_url.'/public/validate_ad_externen.php?session_hash='.$session_hash.'&key='.$ad_key;

	$return = file_get_contents($verify_url);	
	$return = json_decode($return);
	
	
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object)");
		exit;
	}
	
	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid)");
		exit;
	}				
						
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid)");
		exit;
	}						
						
						
	if(!property_exists($return, 'ad_externen_default_ou')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen ad_externen_default_ou)");
		exit;
	}	
	
	$zoek_genest = 'true';
	if(property_exists($return, 'zoek_genest')){
		$zoek_genest = $return->zoek_genest;
	}
	log_to_file($logfolder, "Genest zoeken: $zoek_genest");
	
	$ou = $return->ad_externen_default_ou;
						
	$arr_data=array();
	log_to_file($logfolder, "powershell -command C:\\toolbox\\powershell\\getADExternenJson.ps1 -ou '$ou' -zoekgenest '$zoek_genest'");
	exec("powershell -command C:\\toolbox\\powershell\\getADExternenJson.ps1 -ou '$ou' -zoekgenest '$zoek_genest'",$arr_data);
								

	if(!is_array($arr_data)){	
		show_error_and_log($logfolder, "Geen array teruggekregen vanuit de AD");
		exit;
	}	
	
	if(substr($arr_data[0], 0, 4) == 'Fout'){
		show_error_and_log($logfolder, $arr_data[0]);
		exit;
	}
	
	log_to_file($logfolder, "Output van getExternenJson (AD) verzonden naar $ip");
	
	foreach($arr_data as $str_data){
		echo $str_data;
	}

?>